#include "commonheaders.h"
#include "classes-menu.h"

extern BITMAP *checkmark;
extern bool debug;
extern bool mouse_inarea(short window_lft_pos, short window_top_pos, short window_width, short window_height);

MenuItem::MenuItem(char *text, void (*funct)(void)) {
    label = text;
    flag = false;
    hover = false;
    check = false;
    pressed = false;
    this->funct = funct;
}
bool MenuItem::Check(short xLocation, short yLocation, short width) {
    if(mouse_inarea(xLocation - 4, 16 + (yLocation * 16), width + 35, 15)) {
        hover = true;
        if(mouse_b & 1) {
            pressed = true;
        } else {
            if(pressed) {
                funct();
                if(flag) {
                    if(!check) {
                        check = true;
                    } else {
                        check = false;    
                    }
                }
                pressed = false;
                return true;
            }
        }
    } else {
        hover = false;
        if(pressed) pressed = false; 
    }
    return false;
}
void MenuItem::Flagged(bool checked) {
    flag = true;
    check = checked;
}
void MenuItem::Draw(BITMAP *output, short xLocation, short yLocation, short width) {
    if(hover) {
        rectfill(output, xLocation - 15, yLocation - 3, xLocation + width + 18, yLocation + 10, makecol(128, 128, 128));
        rect(output, xLocation - 16, yLocation - 4, xLocation + width + 19, yLocation + 11, makecol(64, 64, 64));
        textprintf(output, font, xLocation + 1, yLocation + 1, WHITE, label);
        textprintf(output, font, xLocation, yLocation, BLACK, label);  
    } else {
        textprintf(output, font, xLocation + 1, yLocation + 1, BLACK, label);
        textprintf(output, font, xLocation, yLocation, WHITE, label);
    }
    if(flag) {
        if(check) draw_sprite(output, checkmark, xLocation - 10, yLocation);  
    }
}


MenuDir::MenuDir(char *text, short xLocation) {
    items = 0;
    active = false;
    hover = false;
    xPos = xLocation;
    label = (char *)calloc(strlen(text)+1, sizeof(char));
    strcpy(label, text);
    label[strlen(text)+1] = '\0';
    width = strlen(text) * 8 + 16;
    MenuItems = (MenuItem **)malloc(sizeof(MenuItem *));
}
bool MenuDir::AddItem(char *text, void (*funct)(void)) {
    //printf("Adding New Menu Item...\n");
    MenuItems = (MenuItem **)realloc(MenuItems, sizeof(MenuItem *) * (items + 1));
    MenuItems[items] = new MenuItem(text, funct);
    if(MenuItems[items] == NULL) {
        printf("Error in creation!\n");
        return false;
    }
    //printf("Creation Successful of %i.\n", items);
    items ++;
    if(strlen(text) * 8 > width) width = strlen(text) * 8;
    for(int i = 0; i < items; i ++)
    {
        if(MenuItems[i]) printf("%i", i);
        else printf(" ");
    }
    printf("\n\n");
    return true;
}
bool MenuDir::Check(void) {
    if(mouse_inarea(xPos - 5, 0, (strlen(this->label) * 8) + 4, 16)) {
        if(mouse_b & 1) {
            active = true;
        }
        hover = true;
    } else {
        if(active && mouse_inarea(xPos - 15, 16, width + 57, (items * 16) + 10)) {
            short i;
            for(i = 0; i < items; i ++) {
                if(MenuItems[i]) {
                    if(MenuItems[i]->Check(xPos, i, width)) {
                        active = false;
                    }
                }
            }
        } else {
            if(mouse_b & 1) {
                active = false;
            }
        }
        hover = false;
    }
    if(active) {
        short i;
        for(i = 0; i < items; i ++) {
            if(MenuItems[i]) {
                MenuItems[i]->Check(xPos, i, width);
            }
        }
    }
    return active;
}
void MenuDir::Flagged(bool checked) {
    if(MenuItems[items - 1]) {
        MenuItems[items - 1]->Flagged(checked);
    }
}
void MenuDir::Draw(BITMAP *output) {
    if(hover) {
        rectfill(output, xPos - 3, 2, xPos + (strlen(this->label) * 8) + 2, 14, makecol(128, 128, 128));
        rect(output, xPos - 4, 1, xPos + (strlen(this->label) * 8) + 3, 15, makecol(64, 64, 64));
        textprintf(output, font, xPos + 1, 5, WHITE, label);
        textprintf(output, font, xPos, 4, BLACK, label);   
    } else {
        textprintf(output, font, xPos + 1, 5, BLACK, label);
        textprintf(output, font, xPos, 4, WHITE, label);
    }
    
    if(active) {
        rect(output, xPos - 5, 0, xPos + (strlen(label) * 8) + 4, 16, BLACK);
        rectfill(output, xPos - 5, 16, xPos + width + 32, 16 + (items * 16), WIN_COLOUR);
        rect(output, xPos - 5, 16, xPos + width + 32, 16 + (items * 16), BLACK);
        
        short i;
        for(i = 0; i < items; i ++) {
            if(MenuItems[i]) {
                if(debug) printf("Drawing Item %i\n", i);
                MenuItems[i]->Draw(output, xPos + 12, 21 + i * 16, width);
            }
        }
    }
}


Menu::Menu(void) {
    if(debug) printf("Initializing Menu...\n");
    dirs = 0;
    xPos = 12;
    if(debug) printf("Allocating Directories...\n");
    MenuDirs = (MenuDir **)malloc(sizeof(MenuDir *));
    if(debug) printf("Initialization Complete.\n");
}
bool Menu::AddDir(char *text) {
    if(debug) printf("Adding New Directory...\n");
    MenuDirs = (MenuDir **)realloc(MenuDirs, sizeof(MenuDir *) * (dirs + 1));
    MenuDirs[dirs] = new MenuDir(text, xPos);
    if(debug) printf("Creation Successful.\n");
    xPos += strlen(text) * 8 + 12;
    dirs ++;
    return true;
}
bool Menu::AddItem(char *text, void (*funct)(void)) {
    if(MenuDirs[dirs - 1]) {
        return MenuDirs[dirs - 1]->AddItem(text, funct);
    }
    return false;
}
bool Menu::Check(void) {
    short i;
    bool active = false;
    for(i = 0; i < dirs; i ++) {
        if(MenuDirs[i]) {
            if(MenuDirs[i]->Check()) {
                active = true;
            }
        }
    }
    return active;
}
void Menu::Flagged(bool checked) {
    if(MenuDirs[dirs - 1]) {
        MenuDirs[dirs - 1]->Flagged(checked);
    }
}
void Menu::Draw(BITMAP *output) {
    rectfill(output, 0, 0, WIN_WIDTH, 16, WIN_COLOUR);
    hline(output, 0, 16, WIN_WIDTH, WHITE);
    
    short i;
    for(i = 0; i < dirs; i ++) {
        if(MenuDirs[i]) {
            MenuDirs[i]->Draw(output);
        }
    }
}

